<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>تسجيل شركة - Master‑HR</title>
    <link rel="stylesheet" href="/admin.css">
    <style>
        /* keep minimal inline adjustments similar to jobseeker form */
        body{display:flex;align-items:center;justify-content:center;min-height:100vh}
        .card{padding:20px;border-radius:8px;background:#071124;color:#e6eef8}
        .grid{display:grid;gap:12px}
        .grid label{display:block}
        .btn{background:#0ea5a4;color:#042024;padding:10px;border-radius:8px;border:none}
    </style>
</head>
<body>
<form method="post" action="<?php echo e(route('register.company.perform')); ?>" class="card" style="width:560px">
    <?php echo csrf_field(); ?>
    <h2 style="margin:0 0 12px">تسجيل شركة</h2>

    <?php if($errors->any()): ?>
        <div style="background:#fff1f2;padding:10px;border-radius:6px;margin-bottom:12px;color:#7f1d1d">
            <strong>وجدت أخطاء:</strong>
            <ul style="margin:6px 0 0;padding-left:18px">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($e); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <div class="grid" style="grid-template-columns:1fr 1fr">
        <label>الاسم الأول للممثل<input name="first_name" value="<?php echo e(old('first_name')); ?>" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
        <label>الاسم الأخير للممثل<input name="last_name" value="<?php echo e(old('last_name')); ?>" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
        <label>اسم المستخدم<input name="username" value="<?php echo e(old('username')); ?>" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
        <label>البريد الإلكتروني<input name="email" value="<?php echo e(old('email')); ?>" type="email" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
        <label>كلمة المرور<input name="password" type="password" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
        <label>تأكيد كلمة المرور<input name="password_confirmation" type="password" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
        <label style="grid-column:1/-1">اسم الشركة<input name="company_name" value="<?php echo e(old('company_name')); ?>" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
        <label>الصناعة
            <select name="industry" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
                <option value="">اختر الصناعة</option>
                <option value="technology" <?php echo e(old('industry')=='technology'?'selected':''); ?>>التكنولوجيا</option>
                <option value="healthcare" <?php echo e(old('industry')=='healthcare'?'selected':''); ?>>الرعاية الصحية</option>
                <option value="finance" <?php echo e(old('industry')=='finance'?'selected':''); ?>>التمويل</option>
                <option value="education" <?php echo e(old('industry')=='education'?'selected':''); ?>>التعليم</option>
                <option value="manufacturing" <?php echo e(old('industry')=='manufacturing'?'selected':''); ?>>التصنيع</option>
                <option value="other" <?php echo e(old('industry')=='other'?'selected':''); ?>>أخرى</option>
            </select>
        </label>
        <label>هاتف الشركة<input name="company_phone" value="<?php echo e(old('company_phone')); ?>" type="tel" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
        <label style="grid-column:1/-1">العنوان / الموقع<input name="location" value="<?php echo e(old('location')); ?>" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
    </div>
    <div style="height:12px"></div>
    <button class="btn" type="submit" style="width:100%">تسجيل الشركة</button>
    <div style="margin-top:8px;text-align:center"><a href="/">عودة للموقع</a></div>
 </form>
</body>
</html>
<?php /**PATH C:\Users\Eng.Mohamed-Ashraf\Desktop\git\Master-HR-Laravel\resources\views/auth/register_company.blade.php ENDPATH**/ ?>