<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>لوحة التحكم - <?php echo $__env->yieldContent('title', 'Master-HR'); ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="/admin.css">
    <!-- Tom Select (CDN) for enhanced multi-selects -->
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.2.2/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <?php echo $__env->yieldPushContent('head'); ?>
    <?php echo $__env->yieldContent('styles'); ?>
    <?php echo $__env->yieldContent('head'); ?>
    <?php echo $__env->yieldPushContent('styles'); ?>
    <?php echo $__env->yieldPushContent('scripts-head'); ?>
    <?php echo $__env->yieldContent('scripts-head'); ?>
    <?php echo $__env->yieldContent('meta'); ?>
    <?php echo $__env->yieldPushContent('meta'); ?>
    <?php echo $__env->yieldContent('links'); ?>
    <?php echo $__env->yieldPushContent('links'); ?>
    <?php echo $__env->yieldContent('title-after'); ?>
</head>
<body>
<aside class="sidebar">
    <div class="brand">
        <i class="fa-solid fa-briefcase" style="color:#22d3ee"></i>
        <a href="<?php echo e(route('admin.dashboard')); ?>" style="font-weight:800;color:#e2e8f0">Master‑HR</a>
    </div>
    <nav class="menu">
        <a href="<?php echo e(route('admin.dashboard')); ?>" class="<?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>"><i class="fa-solid fa-gauge"></i> لوحة التحكم</a>
        <a href="<?php echo e(route('admin.companies.index')); ?>"><i class="fa-solid fa-buildings"></i> الشركات</a>
        <a href="<?php echo e(route('admin.jobs.index')); ?>"><i class="fa-solid fa-clipboard-list"></i> الوظائف</a>
        <a href="<?php echo e(route('admin.categories.index')); ?>"><i class="fa-solid fa-layer-group"></i> التصنيفات</a>
        <a href="<?php echo e(route('admin.skills.index')); ?>"><i class="fa-solid fa-wand-magic-sparkles"></i> المهارات</a>
        <a href="<?php echo e(route('admin.locations.index')); ?>"><i class="fa-solid fa-location-dot"></i> المدن</a>
        <a href="<?php echo e(route('admin.users.index')); ?>"><i class="fa-solid fa-users"></i> المستخدمون</a>
        <a href="<?php echo e(route('admin.job-seekers.index')); ?>"><i class="fa-solid fa-user-tie"></i> الباحثون</a>
        <a href="<?php echo e(route('admin.applications.index')); ?>"><i class="fa-solid fa-paper-plane"></i> الطلبات</a>
        <a href="<?php echo e(route('admin.events.index')); ?>"><i class="fa-solid fa-calendar-days"></i> الفعاليات</a>
        <a href="<?php echo e(route('admin.newsletter-subscribers.index')); ?>"><i class="fa-solid fa-envelope-open-text"></i> النشرة</a>
        <a href="<?php echo e(route('admin.settings.index')); ?>"><i class="fa-solid fa-gear"></i> الإعدادات</a>
    </nav>
    <div style="padding:16px;color:#94a3b8;font-size:12px">© <?php echo e(date('Y')); ?> Master‑HR</div>
    </aside>
<main class="content">
    <div class="topbar">
        <div>
            <strong><?php echo $__env->yieldContent('page-title','لوحة التحكم'); ?></strong>
            <div class="muted" style="font-size:12px">مرحباً بك في لوحة إدارة Master‑HR</div>
        </div>
        <div>
            <a class="btn" href="/"><i class="fa-solid fa-globe"></i> عرض الموقع</a>
            <form method="post" action="<?php echo e(route('admin.logout')); ?>" style="display:inline-block;margin-inline-start:8px">
                <?php echo csrf_field(); ?>
                <button class="btn" type="submit"><i class="fa-solid fa-right-from-bracket"></i> تسجيل الخروج</button>
            </form>
        </div>
    </div>
    <div style="padding:20px">
        <?php echo $__env->yieldContent('content'); ?>
    </div>
</main>
<?php echo $__env->yieldPushContent('body-end'); ?>
<script src="https://cdn.jsdelivr.net/npm/tom-select@2.2.2/dist/js/tom-select.complete.min.js"></script>
<script>
    // Initialize Tom Select for languages multi-selects
    document.addEventListener('DOMContentLoaded', function () {
        try {
            var el = document.querySelector('select[name="languages[]"]');
            if (el) {
                var ts = new TomSelect(el, {
                    plugins: ['remove_button'],
                    maxItems: null,
                    persist: false,
                    create: false,
                    placeholder: 'اختر لغات...'
                });
                // RTL tweaks: if page is RTL, force Tom Select UI to RTL and right-align text
                var pageDir = document.documentElement.getAttribute('dir') || document.body.getAttribute('dir') || 'ltr';
                if (pageDir.toLowerCase() === 'rtl') {
                    var wrapper = el.nextElementSibling; // TomSelect inserts wrapper after select
                    if (wrapper) {
                        wrapper.style.direction = 'rtl';
                        // right-align search input
                        var input = wrapper.querySelector('input[type="text"]');
                        if (input) input.style.textAlign = 'right';
                        // align selected items to the right
                        var items = wrapper.querySelectorAll('.item');
                        items.forEach(function(it){ it.style.float = 'right'; });
                    }
                }
            }
        } catch (e) {
            console.error('TomSelect init error', e);
        }
    });
</script>
<style>
    /* Tom Select RTL small tweaks */
    .ts-control { direction: rtl; }
    .ts-dropdown { direction: rtl; text-align: right; }
    .ts-control .item { float: right; }
</style>
<?php echo $__env->yieldContent('scripts'); ?>
<?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>


<?php /**PATH C:\Users\Eng.Mohamed-Ashraf\Desktop\git\Master-HR-Laravel\resources\views/admin/layouts/app.blade.php ENDPATH**/ ?>