<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $__env->yieldContent('title','Master‑HR'); ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="/assets/css/style.css">
    <link rel="stylesheet" href="/assets/css/modern-home.css">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700;800&display=swap" rel="stylesheet">
    <style>body{font-family:'Cairo',sans-serif}</style>
</head>
<body>
    <header>
        <nav class="navbar navbar-expand-lg navbar-dark fixed-top" id="mainNav">
            <div class="container">
                <a class="navbar-brand d-flex align-items-center" href="/">
                    <img src="/assets/img/logo.jpg" alt="MasterHR" style="height:40px; width:auto; margin-left:8px; border-radius:6px; object-fit:cover;">
                    <span>Master-HR</span>
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarNav">
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item"><a class="nav-link" href="/">الرئيسية</a></li>
                        <li class="nav-item"><a class="nav-link" href="/jobs">الوظائف</a></li>
                        <li class="nav-item"><a class="nav-link" href="/companies">الشركات</a></li>
                        <li class="nav-item"><a class="nav-link" href="/contact">اتصل بنا</a></li>
                    </ul>
                </div>
                <div class="d-flex align-items-center gap-2">
                    <?php if(auth()->guard()->check()): ?>
                        <?php if(auth()->user()->user_type==='admin' || auth()->user()->user_type==='superadmin'): ?>
                            <a class="btn btn-primary" href="<?php echo e(route('admin.dashboard')); ?>">لوحة التحكم</a>
                        <?php elseif(auth()->user()->user_type==='company'): ?>
                            <a class="btn btn-primary" href="<?php echo e(route('company.dashboard')); ?>">لوحة الشركة</a>
                        <?php else: ?>
                            <a class="btn btn-primary" href="<?php echo e(route('account.dashboard')); ?>">حسابي</a>
                        <?php endif; ?>
                        <form method="POST" action="<?php echo e(route('logout')); ?>" style="display:inline;margin:0">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-outline-light">تسجيل الخروج</button>
                        </form>
                    <?php else: ?>
                        <a class="btn btn-outline-light" href="<?php echo e(route('login.show')); ?>">تسجيل الدخول</a>
                        <a class="btn btn-primary" href="<?php echo e(route('register.company.show')); ?>">تسجيل شركة</a>
                        <a class="btn btn-outline-primary" href="<?php echo e(route('register.jobseeker.show')); ?>">تسجيل متقدم</a>
                    <?php endif; ?>
                </div>
            </div>
        </nav>
    </header>
    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>
        <!-- Footer -->
    <footer class="footer py-4">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <h5 class="text-white">Master-HR</h5>
                    <p class="text-muted">نربط بين الموهوبين والشركات لبناء مستقبل أفضل</p>
                </div>
                <div class="col-lg-2 mb-4">
                    <h6 class="text-white">روابط سريعة</h6>
                    <ul class="list-unstyled">
                        <li><a href="#home">الرئيسية</a></li>
                        <li><a href="about.html">من نحن</a></li>
                        <li><a href="jobs.html">الوظائف</a></li>
                        <li><a href="companies.html">الشركات</a></li>
                    </ul>
                </div>
                <div class="col-lg-3 mb-4">
                    <h6 class="text-white">الخدمات</h6>
                    <ul class="list-unstyled">
                        <li><a href="#jobseeker-form">البحث عن الوظائف</a></li>
                        <li><a href="#company-form">تسجيل الشركات</a></li>
                        <li><a href="contact.html">الاستشارات</a></li>
                    </ul>
                </div>
                <div class="col-lg-3 mb-4">
                    <h6 class="text-white">النشرة الإخبارية</h6>
                    <p class="text-muted">احصل على آخر الوظائف والتحديثات</p>
                    <div class="input-group">
                        <input type="email" class="form-control" placeholder="بريدك الإلكتروني">
                        <button class="btn btn-primary" type="button">اشتراك</button>
                    </div>
                </div>
            </div>
            <hr class="my-4">
            <div class="row">
                <div class="col-md-6">
                    <p class="text-muted mb-0">&copy; 2024 Master-HR. جميع الحقوق محفوظة</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <a href="#" class="text-muted me-3">سياسة الخصوصية</a>
                    <a href="#" class="text-muted">الشروط والأحكام</a>
                </div>
            </div>
        </div>
    </footer>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/three.js/r128/three.min.js"></script>
    <script src="/assets/js/main.js"></script>
    <script>
        // Initialize AOS (Animate On Scroll)
        AOS.init({
            duration: 800,
            easing: 'ease-in-out',
            once: true,
            offset: 100
        });
    </script>
</body>
</html>


<?php /**PATH /home/masterhr/public_html/resources/views/frontend/layout.blade.php ENDPATH**/ ?>