<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\CompanyController;
use App\Http\Controllers\Admin\JobController;
use App\Http\Controllers\Admin\JobApplicationController;
use App\Http\Controllers\Admin\JobSeekerController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\SkillController;
use App\Http\Controllers\Admin\LocationController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\NewsletterSubscriberController;
use App\Http\Controllers\Admin\EventController as AdminEventController;
use App\Http\Controllers\Admin\EventRegistrationController as AdminEventRegistrationController;
use App\Http\Controllers\Admin\MessageController as AdminMessageController;
use App\Http\Controllers\Admin\NotificationController as AdminNotificationController;
use App\Http\Controllers\Admin\AuthController as AdminAuthController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\PublicRegistrationController;

Route::get('/', function () {
    return view('frontend.home');
});
Route::view('/jobs', 'frontend.jobs');
Route::view('/companies', 'frontend.companies');
Route::view('/contact', 'frontend.contact');

Route::get('/login', [AuthController::class, 'showLogin'])->name('login.show');
Route::post('/login', [AuthController::class, 'login'])->name('login.perform');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
Route::get('/register/company', [PublicRegistrationController::class, 'showCompanyForm'])->name('register.company.show');
Route::post('/register/company', [PublicRegistrationController::class, 'registerCompany'])->name('register.company.perform');
Route::get('/register/jobseeker', [PublicRegistrationController::class, 'showJobSeekerForm'])->name('register.jobseeker.show');
Route::post('/register/jobseeker', [PublicRegistrationController::class, 'registerJobSeeker'])->name('register.jobseeker.perform');

// Languages library (public)
Route::get('/library/languages', [App\Http\Controllers\LibraryController::class, 'languages'])->name('library.languages');

// Direct Admin Route for Super Admin

Route::prefix('admin')->name('admin.')->middleware('admin')->group(function () {
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
    Route::resource('companies', CompanyController::class);
    Route::resource('jobs', JobController::class);
    Route::resource('applications', JobApplicationController::class);
    Route::resource('job-seekers', JobSeekerController::class);
    Route::resource('users', UserController::class);
    Route::resource('categories', CategoryController::class);
    Route::resource('skills', SkillController::class)->only(['index']);
    Route::resource('locations', LocationController::class)->only(['index']);
    Route::resource('settings', SettingController::class)->only(['index']);
    Route::resource('newsletter-subscribers', NewsletterSubscriberController::class)->only(['index']);
    Route::resource('events', AdminEventController::class)->only(['index']);
    Route::resource('event-registrations', AdminEventRegistrationController::class)->only(['index']);
    Route::resource('messages', AdminMessageController::class)->only(['index']);
    Route::resource('notifications', AdminNotificationController::class)->only(['index']);
    Route::post('logout', [AdminAuthController::class, 'logout'])->name('logout');
});

Route::prefix('company')->name('company.')->middleware('company')->group(function () {
    Route::get('/', [\App\Http\Controllers\Company\PortalController::class, 'dashboard'])->name('dashboard');
    Route::get('/jobs', [\App\Http\Controllers\Company\PortalController::class, 'jobs'])->name('jobs');
    Route::get('/jobs/{job}/applications', [\App\Http\Controllers\Company\PortalController::class, 'jobApplications'])->name('jobs.applications');
    // company settings
    Route::get('/settings', [\App\Http\Controllers\Company\SettingsController::class, 'edit'])->name('settings.edit');
    Route::post('/settings', [\App\Http\Controllers\Company\SettingsController::class, 'update'])->name('settings.update');
});

Route::prefix('account')->name('account.')->middleware('jobseeker')->group(function () {
    Route::get('/', [\App\Http\Controllers\Account\DashboardController::class, 'index'])->name('dashboard');
    Route::get('/applications', [\App\Http\Controllers\Account\ApplicationController::class, 'index'])->name('applications.index');
    Route::get('/profile/edit', [\App\Http\Controllers\Account\ProfileController::class, 'edit'])->name('profile.edit');
    Route::post('/profile/edit', [\App\Http\Controllers\Account\ProfileController::class, 'update'])->name('profile.update');
});
