@extends('frontend.layout')
@section('title','الوظائف | Master‑HR')
@section('content')
    <section class="hero" style="padding:40px 0;background:#f8fafc">
        <div class="container">
            <h1>الوظائف المتاحة</h1>
            <p>استعرض أحدث الوظائف وتقدم مباشرة.</p>
        </div>
    </section>
    <section class="container" style="padding:24px 0">
        {{-- لاحقاً: ربط قائمة الوظائف من قاعدة البيانات --}}
        <div style="display:grid;grid-template-columns:repeat(3,minmax(0,1fr));gap:16px">
            @foreach(\App\Models\Job::latest('id')->limit(9)->get() as $job)
                <div class="card" style="padding:16px">
                    <div style="font-weight:700">{{ $job->job_title }}</div>
                    <div style="color:#64748b">{{ optional($job->company)->company_name }} • {{ $job->location }}</div>
                    <div style="margin-top:8px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis">{{ Str::limit($job->job_description, 120) }}</div>
                    <div style="margin-top:10px">
                        <a class="btn" href="#">التفاصيل</a>
                    </div>
                </div>
            @endforeach
        </div>
    </section>
@endsection


