@extends('frontend.layout')
@section('title','الشركات | Master‑HR')
@section('content')
    <section class="hero" style="padding:40px 0;background:#f8fafc">
        <div class="container">
            <h1>الشركات</h1>
            <p>استكشف الشركات وتعرّف على ملفاتها.</p>
        </div>
    </section>
    <section class="container" style="padding:24px 0">
        <div style="display:grid;grid-template-columns:repeat(4,minmax(0,1fr));gap:16px">
            @foreach(\App\Models\Company::latest('id')->limit(12)->get() as $c)
                <div class="card" style="padding:16px">
                    <div style="font-weight:700">{{ $c->company_name }}</div>
                    <div style="color:#64748b">{{ $c->industry }} • {{ $c->location }}</div>
                    <div style="margin-top:8px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis">{{ Str::limit($c->company_description, 100) }}</div>
                </div>
            @endforeach
        </div>
    </section>
@endsection


