@extends('admin.layouts.app')
@section('title','المهارات')
@section('page-title','المهارات')
@section('content')
<form method="get" action="" style="display:flex;gap:8px;margin-bottom:16px">
    <input name="q" value="{{ request('q') }}" placeholder="ابحث باسم المهارة" style="background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px 12px;border-radius:10px;min-width:260px">
    <button class="btn" type="submit">بحث</button>
</form>
<table class="table">
    <thead><tr><th>المهارة</th><th>نشطة</th></tr></thead>
    <tbody>
    @foreach($skills as $s)
        <tr>
            <td>{{ $s->skill_name }}</td>
            <td>{!! $s->is_active ? '<span class="badge">نعم</span>' : '<span class="badge">لا</span>' !!}</td>
        </tr>
    @endforeach
    </tbody>
</table>
<div style="margin-top:12px">{{ $skills->links() }}</div>
@endsection


