@extends('admin.layouts.app')
@section('title','الوظائف')
@section('page-title','الوظائف')
@section('content')
    <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:16px">
        <form method="get" action="" style="display:flex;gap:8px">
            <input name="q" value="{{ request('q') }}" placeholder="ابحث بعنوان الوظيفة أو المدينة" style="background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px 12px;border-radius:10px;min-width:260px">
            <button class="btn" type="submit"><i class="fa-solid fa-magnifying-glass"></i> بحث</button>
        </form>
        <a class="btn" href="{{ route('admin.jobs.create') }}"><i class="fa-solid fa-plus"></i> وظيفة جديدة</a>
    </div>
    <table class="table">
        <thead>
        <tr>
            <th>العنوان</th>
            <th>الشركة</th>
            <th>التصنيف</th>
            <th>المدينة</th>
            <th>الحالة</th>
            <th></th>
        </tr>
        </thead>
        <tbody>
        @foreach($jobs as $job)
            <tr>
                <td><a href="{{ route('admin.jobs.show',$job) }}">{{ $job->job_title }}</a></td>
                <td>{{ optional($job->company)->company_name }}</td>
                <td>{{ optional($job->category)->name }}</td>
                <td>{{ $job->location }}</td>
                <td>{!! $job->is_active ? '<span class="badge">نشط</span>' : '<span class="badge">موقوف</span>' !!}</td>
                <td style="text-align:end">
                    <a class="btn" href="{{ route('admin.jobs.edit',$job) }}"><i class="fa-solid fa-pen"></i> تعديل</a>
                    <form action="{{ route('admin.jobs.destroy',$job) }}" method="post" style="display:inline-block" onsubmit="return confirm('حذف الوظيفة؟');">
                        @csrf
                        @method('delete')
                        <button class="btn" type="submit"><i class="fa-solid fa-trash"></i> حذف</button>
                    </form>
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
    <div style="margin-top:12px">{{ $jobs->links() }}</div>
@endsection


