@extends('admin.layouts.app')
@section('title','تعديل وظيفة')
@section('page-title','تعديل وظيفة')
@section('content')
<form method="post" action="{{ route('admin.jobs.update',$job) }}" class="card" style="max-width:980px">
@csrf
@method('put')
<div class="grid" style="grid-template-columns:1fr 1fr">
    <label>الشركة
        <select name="company_id" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
            @foreach($companies as $id=>$name)
                <option value="{{ $id }}" @selected($job->company_id==$id)>{{ $name }}</option>
            @endforeach
        </select>
    </label>
    <label>التصنيف
        <select name="category_id" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
            <option value="">—</option>
            @foreach($categories as $id=>$name)
                <option value="{{ $id }}" @selected($job->category_id==$id)>{{ $name }}</option>
            @endforeach
        </select>
    </label>
    <label>العنوان<input name="job_title" value="{{ $job->job_title }}" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
    <label>المدينة<input name="location" value="{{ $job->location }}" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
    <label>الراتب الأدنى<input name="salary_min" type="number" step="0.01" value="{{ $job->salary_min }}" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
    <label>الراتب الأقصى<input name="salary_max" type="number" step="0.01" value="{{ $job->salary_max }}" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
    <label>نوع العمل
        <select name="job_type" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
            @foreach(['full_time'=>'دوام كامل','part_time'=>'دوام جزئي','contract'=>'عقد','internship'=>'تدريب'] as $key=>$label)
                <option value="{{ $key }}" @selected($job->job_type==$key)>{{ $label }}</option>
            @endforeach
        </select>
    </label>
    <label>الخبرة
        <select name="experience_level" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
            @foreach(['entry'=>'مبتدئ','mid'=>'متوسط','senior'=>'كبير','executive'=>'إداري'] as $key=>$label)
                <option value="{{ $key }}" @selected($job->experience_level==$key)>{{ $label }}</option>
            @endforeach
        </select>
    </label>
    <label style="grid-column:1/-1">المتطلبات<textarea name="requirements" rows="4" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">{{ $job->requirements }}</textarea></label>
    <label style="grid-column:1/-1">الوصف<textarea name="job_description" rows="6" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">{{ $job->job_description }}</textarea></label>
    <label style="grid-column:1/-1">المهارات المطلوبة<textarea name="skills_required" rows="3" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">{{ $job->skills_required }}</textarea></label>
    <label style="display:flex;align-items:center;gap:8px;margin-top:8px"><input type="checkbox" name="is_active" value="1" @checked($job->is_active)> نشطة</label>
</div>
<div style="margin-top:12px">
    <button class="btn" type="submit"><i class="fa-solid fa-save"></i> حفظ</button>
    <a class="btn" href="{{ route('admin.jobs.index') }}">إلغاء</a>
</div>
</form>
@endsection


