@extends('admin.layouts.app')
@section('title','تعديل متقدم')
@section('page-title','تعديل متقدم')
@section('content')
<form method="post" action="{{ route('admin.job-seekers.update',$seeker) }}" class="card" style="max-width:920px" enctype="multipart/form-data">
@csrf
@method('put')
<div class="grid" style="grid-template-columns:1fr 1fr">
    <label>المستخدم
        <select name="user_id" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
            @foreach($users as $id=>$email)
                <option value="{{ $id }}" @selected($seeker->user_id==$id)>{{ $email }}</option>
            @endforeach
        </select>
    </label>
    <label>سنوات الخبرة
        <select name="experience_years" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
            @foreach(['0-1','2-3','4-5','6+'] as $y)
                <option value="{{ $y }}" @selected($seeker->experience_years==$y)>{{ $y }}</option>
            @endforeach
        </select>
    </label>
    <label>الوظيفة الحالية<input name="current_position" value="{{ $seeker->current_position }}" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
    <label>الراتب المتوقع<input name="desired_salary" type="number" step="0.01" value="{{ $seeker->desired_salary }}" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
    <label>المدينة المفضلة<input name="preferred_location" value="{{ $seeker->preferred_location }}" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
    <label>التعليم
        <select name="education_level" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
            @foreach(['high_school'=>'ثانوية','bachelor'=>'بكالوريوس','master'=>'ماجستير','phd'=>'دكتوراه','other'=>'أخرى'] as $k=>$v)
                <option value="{{ $k }}" @selected($seeker->education_level==$k)>{{ $v }}</option>
            @endforeach
        </select>
    </label>
    <label style="grid-column:1/-1">المهارات<textarea name="skills" rows="3" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">{{ $seeker->skills }}</textarea></label>
    <label>السيرة الذاتية (رفع ملف)
        @if($seeker->resume_file)
            <div style="margin-bottom:8px;color:#cbd5e1">ملف حالي: <a href="{{ $seeker->resume_file }}" target="_blank">عرض</a></div>
        @endif
        <input type="file" name="resume_file" accept="application/pdf,application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:8px;border-radius:10px">
    </label>
    <label>اللغات
        @php
            $langOptions = ['ar'=>'العربية','en'=>'الإنجليزية','fr'=>'الفرنسية','es'=>'الإسبانية','other'=>'أخرى'];
            $selectedLangs = is_string($seeker->languages) && $seeker->languages !== '' ? explode(',', $seeker->languages) : [];
        @endphp
        <select name="languages[]" multiple style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px;min-height:48px">
            @foreach($langOptions as $code=>$label)
                <option value="{{ $code }}" {{ in_array($code,$selectedLangs)?'selected':'' }}>{{ $label }}</option>
            @endforeach
        </select>
    </label>
    <label style="grid-column:1/-1">الشهادات<textarea name="certifications" rows="2" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">{{ $seeker->certifications }}</textarea></label>
</div>
<div style="margin-top:12px">
    <button class="btn" type="submit">حفظ</button>
    <a class="btn" href="{{ route('admin.job-seekers.index') }}">إلغاء</a>
</div>
</form>
@endsection


