@extends('admin.layouts.app')
@section('title','إضافة متقدم')
@section('page-title','إضافة متقدم')
@section('content')
<form method="post" action="{{ route('admin.job-seekers.store') }}" class="card" style="max-width:920px">
@csrf
<div class="grid" style="grid-template-columns:1fr 1fr">
    <label>المستخدم
        <select name="user_id" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
            @foreach($users as $id=>$email)
                <option value="{{ $id }}">{{ $email }}</option>
            @endforeach
        </select>
    </label>
    <label>سنوات الخبرة
        <select name="experience_years" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
            @foreach(['0-1','2-3','4-5','6+'] as $y)
                <option value="{{ $y }}">{{ $y }}</option>
            @endforeach
        </select>
    </label>
    <label>الوظيفة الحالية<input name="current_position" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
    <label>الراتب المتوقع<input name="desired_salary" type="number" step="0.01" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
    <label>المدينة المفضلة<input name="preferred_location" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
    <label>التعليم
        <select name="education_level" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
            @foreach(['high_school'=>'ثانوية','bachelor'=>'بكالوريوس','master'=>'ماجستير','phd'=>'دكتوراه','other'=>'أخرى'] as $k=>$v)
                <option value="{{ $k }}">{{ $v }}</option>
            @endforeach
        </select>
    </label>
    <label style="grid-column:1/-1">المهارات<textarea name="skills" rows="3" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></textarea></label>
    <label>السيرة الذاتية (رابط)<input name="resume_file" placeholder="/storage/resumes/..." style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
    <label style="grid-column:1/-1">اللغات<textarea name="languages" rows="2" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></textarea></label>
    <label style="grid-column:1/-1">الشهادات<textarea name="certifications" rows="2" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></textarea></label>
</div>
<div style="margin-top:12px">
    <button class="btn" type="submit">حفظ</button>
    <a class="btn" href="{{ route('admin.job-seekers.index') }}">إلغاء</a>
</div>
</form>
@endsection


