@extends('admin.layouts.app')

@section('title','لوحة التحكم')
@section('page-title','نظرة عامة')

@section('content')
    <div class="grid grid-4">
        <div class="card stat">
            <div>
                <div class="muted">عدد الشركات</div>
                <div style="font-size:28px;font-weight:800">{{ number_format(\App\Models\Company::count()) }}</div>
            </div>
            <i class="fa-solid fa-buildings" style="color:#38bdf8;font-size:28px"></i>
        </div>
        <div class="card stat">
            <div>
                <div class="muted">عدد الوظائف</div>
                <div style="font-size:28px;font-weight:800">{{ number_format(\App\Models\Job::count()) }}</div>
            </div>
            <i class="fa-solid fa-clipboard-list" style="color:#22d3ee;font-size:28px"></i>
        </div>
        <div class="card stat">
            <div>
                <div class="muted">طلبات التوظيف</div>
                <div style="font-size:28px;font-weight:800">{{ number_format(\App\Models\JobApplication::count()) }}</div>
            </div>
            <i class="fa-solid fa-paper-plane" style="color:#60a5fa;font-size:28px"></i>
        </div>
        <div class="card stat">
            <div>
                <div class="muted">المستخدمون</div>
                <div style="font-size:28px;font-weight:800">{{ number_format(\App\Models\User::count()) }}</div>
            </div>
            <i class="fa-solid fa-users" style="color:#818cf8;font-size:28px"></i>
        </div>
    </div>
    <div style="height:16px"></div>
    <div class="grid" style="grid-template-columns:2fr 1fr">
        <div class="card">
            <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:10px">
                <strong>أحدث الوظائف</strong>
                <a class="btn" href="{{ route('admin.jobs.index') }}">المزيد</a>
            </div>
            <table class="table">
                <thead>
                <tr>
                    <th>العنوان</th>
                    <th>الشركة</th>
                    <th>المدينة</th>
                    <th>تاريخ الإضافة</th>
                </tr>
                </thead>
                <tbody>
                @foreach(\App\Models\Job::with('company')->latest('id')->limit(6)->get() as $job)
                    <tr>
                        <td>{{ $job->job_title }}</td>
                        <td>{{ optional($job->company)->company_name }}</td>
                        <td>{{ $job->location }}</td>
                        <td>{{ $job->created_at }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
        <div class="card">
            <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:10px">
                <strong>آخر الطلبات</strong>
                <a class="btn" href="{{ route('admin.applications.index') }}">المزيد</a>
            </div>
            <table class="table">
                <thead>
                <tr>
                    <th>الوظيفة</th>
                    <th>الحالة</th>
                    <th>بتاريخ</th>
                </tr>
                </thead>
                <tbody>
                @foreach(\App\Models\JobApplication::with('job')->latest('id')->limit(6)->get() as $app)
                    <tr>
                        <td>{{ optional($app->job)->job_title }}</td>
                        <td><span class="badge">{{ $app->status }}</span></td>
                        <td>{{ $app->applied_at }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection


