@extends('admin.layouts.app')

@section('title','عرض شركة')
@section('page-title','عرض شركة')

@section('content')
    <div class="grid" style="grid-template-columns:2fr 1fr;gap:16px">
        <div class="card">
            <h3 style="margin-top:0">{{ $company->company_name }}</h3>
            <div class="muted">{{ $company->industry }} - {{ $company->location }}</div>
            <div style="margin-top:12px">{{ $company->company_description }}</div>
        </div>
        <div class="card">
            <div><strong>موثّقة:</strong> {{ $company->is_verified ? 'نعم' : 'لا' }}</div>
            <div><strong>تقييم:</strong> {{ number_format($company->rating,2) }}</div>
            <div><strong>موقع:</strong> <a href="{{ $company->company_website }}" target="_blank">{{ $company->company_website }}</a></div>
            <div><strong>بريد:</strong> {{ $company->company_email }}</div>
            <div><strong>هاتف:</strong> {{ $company->company_phone }}</div>
        </div>
    </div>

    <div style="height:16px"></div>
    <div class="card">
        <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:10px">
            <strong>وظائف الشركة</strong>
            <a class="btn" href="{{ route('admin.jobs.index') }}">الذهاب للوظائف</a>
        </div>
        <table class="table">
            <thead><tr><th>العنوان</th><th>المستوى</th><th>النوع</th><th>تاريخ</th></tr></thead>
            <tbody>
            @foreach($company->jobs()->latest('id')->limit(10)->get() as $job)
                <tr>
                    <td>{{ $job->job_title }}</td>
                    <td>{{ $job->experience_level }}</td>
                    <td>{{ $job->job_type }}</td>
                    <td>{{ $job->created_at }}</td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
@endsection


