@extends('admin.layouts.app')

@section('title','الشركات')
@section('page-title','الشركات')

@section('content')
    <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:16px">
        <form method="get" action="" style="display:flex;gap:8px">
            <input name="q" value="{{ request('q') }}" placeholder="ابحث بالاسم أو القطاع أو المدينة" style="background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px 12px;border-radius:10px;min-width:260px">
            <button class="btn" type="submit"><i class="fa-solid fa-magnifying-glass"></i> بحث</button>
        </form>
        <a class="btn" href="{{ route('admin.companies.create') }}"><i class="fa-solid fa-plus"></i> شركة جديدة</a>
    </div>
    <table class="table">
        <thead>
        <tr>
            <th>الاسم</th>
            <th>القطاع</th>
            <th>المدينة</th>
            <th>موثّقة</th>
            <th>التقييم</th>
            <th></th>
        </tr>
        </thead>
        <tbody>
        @foreach($companies as $company)
            <tr>
                <td><a href="{{ route('admin.companies.show',$company) }}">{{ $company->company_name }}</a></td>
                <td>{{ $company->industry }}</td>
                <td>{{ $company->location }}</td>
                <td>{!! $company->is_verified ? '<span class="badge">نعم</span>' : '<span class="badge">لا</span>' !!}</td>
                <td>{{ number_format($company->rating,2) }}</td>
                <td style="text-align:end">
                    <a class="btn" href="{{ route('admin.companies.edit',$company) }}"><i class="fa-solid fa-pen"></i> تعديل</a>
                    <form action="{{ route('admin.companies.destroy',$company) }}" method="post" style="display:inline-block" onsubmit="return confirm('حذف الشركة؟');">
                        @csrf
                        @method('delete')
                        <button class="btn" type="submit"><i class="fa-solid fa-trash"></i> حذف</button>
                    </form>
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
    <div style="margin-top:12px">{{ $companies->links() }}</div>
@endsection


