@extends('admin.layouts.app')
@section('title','التصنيفات')
@section('page-title','التصنيفات')
@section('content')
<div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:16px">
    <form method="get" action="" style="display:flex;gap:8px">
        <input name="q" value="{{ request('q') }}" placeholder="ابحث بالاسم" style="background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px 12px;border-radius:10px;min-width:260px">
        <button class="btn" type="submit">بحث</button>
    </form>
    <a class="btn" href="{{ route('admin.categories.create') }}"><i class="fa-solid fa-plus"></i> تصنيف جديد</a>
</div>
<table class="table">
    <thead><tr><th>الاسم</th><th>نشط</th><th>أيقونة</th><th></th></tr></thead>
    <tbody>
    @foreach($categories as $c)
        <tr>
            <td>{{ $c->name }}</td>
            <td>{!! $c->is_active ? '<span class="badge">نعم</span>' : '<span class="badge">لا</span>' !!}</td>
            <td>{{ $c->icon }}</td>
            <td style="text-align:end">
                <a class="btn" href="{{ route('admin.categories.edit',$c) }}">تعديل</a>
                <form action="{{ route('admin.categories.destroy',$c) }}" method="post" style="display:inline-block" onsubmit="return confirm('حذف التصنيف؟');">
                    @csrf
                    @method('delete')
                    <button class="btn" type="submit">حذف</button>
                </form>
            </td>
        </tr>
    @endforeach
    </tbody>
</table>
<div style="margin-top:12px">{{ $categories->links() }}</div>
@endsection


