@extends('frontend.layout')
@section('title','تعديل الملف')
@section('content')
<div class="container py-4">
    <h3>تعديل الملف</h3>
    <form method="post" action="{{ route('account.profile.update') }}">
        @csrf
        <div class="mb-3">
            <label>الاسم الأول</label>
            <input name="first_name" value="{{ old('first_name', $user->first_name) }}" class="form-control" />
        </div>
        <div class="mb-3">
            <label>الاسم الأخير</label>
            <input name="last_name" value="{{ old('last_name', $user->last_name) }}" class="form-control" />
        </div>
        <div class="mb-3">
            <label>الموقع المفضل</label>
            <input name="preferred_location" value="{{ old('preferred_location', $jobSeeker->preferred_location ?? '') }}" class="form-control" />
        </div>
        <div class="mb-3">
            <label>المستوى التعليمي</label>
            <select name="education_level" class="form-control">
                <option value="">اختر</option>
                <option value="bachelor" {{ (old('education_level', $jobSeeker->education_level ?? '')=='bachelor')? 'selected':'' }}>بكالوريوس</option>
                <option value="master" {{ (old('education_level', $jobSeeker->education_level ?? '')=='master')? 'selected':'' }}>ماجستير</option>
                <option value="phd" {{ (old('education_level', $jobSeeker->education_level ?? '')=='phd')? 'selected':'' }}>دكتوراه</option>
            </select>
        </div>
        <button class="btn btn-primary">حفظ</button>
    </form>
</div>
@endsection
