@extends('frontend.layout')
@section('title','حسابي')
@section('content')
<div class="container py-5">
    <h2>مرحباً {{ auth()->user()->first_name }}</h2>

    <ul class="nav nav-tabs">
        <li class="nav-item"><a class="nav-link active" href="#profile">الملف الشخصي</a></li>
        @can('manage', $jobSeeker)
            <li class="nav-item"><a class="nav-link" href="#applications">طلباتي</a></li>
            <li class="nav-item"><a class="nav-link" href="#edit">تعديل الملف</a></li>
        @endcan
        <li class="nav-item"><a class="nav-link" href="#recommended">وظائف مقترحة</a></li>
    </ul>

    <div class="card mt-3 p-3">
        <h4>ملفي الشخصي</h4>
        <p>التعليم: {{ $jobSeeker->education_level ?? 'غير محدد' }}</p>
        <p>الموقع المفضل: {{ $jobSeeker->preferred_location ?? 'غير محدد' }}</p>
    </div>

    <div class="mt-4">
        <h4>وظائف مقترحة لك</h4>
        @if($jobs->count())
            <ul>
                @foreach($jobs as $job)
                    <li>{{ $job->job_title }} — {{ $job->company->company_name ?? '' }} — <a href="#">عرض</a></li>
                @endforeach
            </ul>
        @else
            <p>لا توجد وظائف مقترحة حالياً.</p>
        @endif
    </div>
</div>
@endsection


