# Master-HR Website Design Prompt for AI Image Generator

## 🎯 **Project Overview**
Create a modern, professional website design for "Master-HR" - a leading Egyptian recruitment and HR solutions company established in 2001, specializing in connecting Egyptian talent with companies in GCC countries, Libya, and Egypt.

## 🏢 **Company Information**
- **Company Name**: Master-HR (ماستر للتوظيف)
- **Established**: 2001 (23+ years of experience)
- **License**: Egyptian Ministry of Labor (432)
- **Specialization**: HR recruitment, talent acquisition, visa facilitation
- **Target Markets**: Saudi Arabia, UAE, Qatar, Kuwait, Bahrain, Oman, Libya, Egypt
- **Partnerships**: Saudi Embassy in Cairo, Egyptian Ministry of Labor

## 🎨 **Design Requirements**

### **Color Scheme**
- **Background**: #0b1220 (dark blue - main website background)
- **Text**: #fff (white - all text content)
- **Icons**: #38d8ff (bright cyan/light blue - all icons and accents)
- **Secondary Background**: #1a2332 (slightly lighter dark blue for sections)
- **Accent Elements**: #38d8ff (bright cyan for borders, highlights, and interactive elements)
- **Theme**: Dark theme with bright cyan accents

### **Visual Style**
- **Modern & Clean**: Minimalist dark design with bright cyan accents
- **Professional**: Corporate dark theme suitable for B2B services
- **Trustworthy**: Convey reliability and expertise with premium dark aesthetic
- **Arabic RTL**: Right-to-left layout for Arabic content
- **Responsive**: Mobile-first design approach
- **Dark Theme**: Professional dark blue background with bright cyan highlights

## 📱 **Website Sections to Design**

### 1. **Hero Section**
- **Layout**: Two-column layout (text left, image right)
- **Content**: 
  - Main headline: "نقود رحلة التوظيف منذ 2001" (Leading recruitment journey since 2001)
  - Subtitle: About connecting Egyptian talent with GCC companies
  - Statistics: 2001 (start), 500+ companies, 10000+ jobs
  - CTA buttons: "Register as Job Seeker" & "Register Company"
- **Visual Elements**: Professional business people, modern office environment, handshake imagery

### 2. **About Us Section**
- **Layout**: Two-column (content left, company image right)
- **Content**:
  - Company badge: "من نحن" (About Us)
  - Title: "ماستر للتوظيف شركة رائدة" (Master-HR Leading Company)
  - Description: Strategic partner for Egyptian talent recruitment
  - Features: Official license, strategic partnerships, quality commitment
  - Overlay stats: "23+ years of experience"
- **Visual Elements**: Company building, professional team, certificates, handshake

### 3. **Services Section**
- **Layout**: Three-column grid
- **Services**:
  - **Talent Acquisition**: Professional interviews, skill assessment, background checks
  - **Flexible Work Solutions**: Remote work, flexible contracts, temporary positions
  - **Visa Facilitation**: Visa procedures, certifications, full follow-up
- **Visual Elements**: Icons for each service, professional illustrations, modern office scenes

### 4. **Testimonials Section**
- **Layout**: Three-column grid
- **Content**: Customer reviews with 5-star ratings
- **Testimonials**:
  - HR Manager from tech company
  - Recruitment Manager from investment company
  - CEO from development company
- **Visual Elements**: Professional headshots, quote marks, star ratings

### 5. **Partners Section**
- **Layout**: Logo grid (10 company logos)
- **Content**: Partner company logos in grayscale with hover effects
- **Visual Elements**: Professional company logos, clean grid layout

### 6. **Contact Section**
- **Layout**: Two-column (contact info left, form right)
- **Content**:
  - Contact methods: Phone, email, address
  - Contact form: Name, email, subject, message
  - Location: Nasr City, Cairo, Egypt
- **Visual Elements**: Contact icons, office building, map location

## 🖼️ **Image Requirements**

### **Hero Section Images**
- Professional business people in modern office
- Handshake between employer and employee
- Modern recruitment process visualization
- Egyptian professionals in business attire
- GCC country skylines (Riyadh, Dubai, Doha)

### **About Section Images**
- Master-HR office building exterior
- Professional team meeting
- Official certificates and licenses
- Modern office interior with Egyptian and GCC flags

### **Services Section Images**
- Video interview setup
- Remote work environment
- Visa and passport documents
- Professional assessment process

### **Testimonials Section Images**
- Professional headshots of satisfied clients
- Modern office environments
- Team collaboration scenes

### **Contact Section Images**
- Master-HR office building
- Cairo cityscape
- Professional contact center
- Map showing location in Nasr City

## 🎨 **Design Elements**

### **Typography**
- **Font**: Cairo (Arabic), Modern sans-serif for English
- **Headings**: Bold, large sizes (2.5rem - 3.5rem), White color (#fff)
- **Body Text**: Clean, readable (1rem - 1.1rem), White color (#fff) with opacity
- **RTL Support**: Right-to-left text alignment
- **Color**: All text in white (#fff) for contrast against dark background

### **Icons & Graphics**
- **Style**: Modern, minimalist icons
- **Colors**: Bright cyan (#38d8ff) with dark blue background (#0b1220)
- **Usage**: Service icons, contact methods, features
- **Size**: Consistent sizing across sections
- **Theme**: Bright cyan icons on dark backgrounds for high contrast

### **Layout Principles**
- **Grid System**: 12-column responsive grid
- **Spacing**: Generous dark space between sections
- **Alignment**: Clean, organized layout
- **Hierarchy**: Clear visual hierarchy with bright cyan accents on dark background
- **Contrast**: High contrast between white text and dark blue background

## 📐 **Technical Specifications**

### **Dimensions**
- **Desktop**: 1920x1080px, 1440x900px
- **Tablet**: 768x1024px
- **Mobile**: 375x667px, 414x896px

### **File Formats**
- **Images**: High-resolution PNG/JPG
- **Icons**: SVG format preferred
- **Logos**: Vector format (SVG/AI)

## 🌟 **Key Visual Themes**

### **Professionalism**
- Clean, corporate dark design
- High-quality imagery with dark theme
- Professional dark color palette with bright cyan accents
- Trust-building elements with premium dark aesthetic

### **Cultural Sensitivity**
- Arabic text integration
- Middle Eastern business culture
- Professional attire appropriate for region
- Respectful representation of diversity

### **Modern Technology**
- Contemporary dark web design trends
- Clean, minimalist dark aesthetics
- Professional photography style with dark theme
- Modern office environments with bright cyan lighting

## 🎯 **Target Audience**
- **Primary**: HR managers, recruitment professionals, company executives
- **Secondary**: Job seekers, professionals looking for opportunities
- **Geographic**: Egypt, Saudi Arabia, UAE, Qatar, Kuwait, Bahrain, Oman, Libya

## 📝 **Content Tone**
- **Professional**: Business-focused language
- **Trustworthy**: Emphasizing experience and reliability
- **Modern**: Contemporary approach to recruitment
- **Bilingual**: Arabic primary, English secondary

---

## 🚀 **AI Image Generation Instructions**

Use this prompt to generate website mockups, hero images, service illustrations, and other visual elements for the Master-HR website. Focus on:

1. **Professional business photography style with dark theme**
2. **Modern, clean dark design aesthetics**
3. **Dark blue background (#0b1220) with bright cyan (#38d8ff) accents**
4. **Arabic/Middle Eastern business context**
5. **High-quality, corporate dark imagery**
6. **Responsive design considerations**
7. **High contrast between white text and dark backgrounds**
8. **Bright cyan lighting effects and accents**

Generate multiple variations for each section to provide design options and ensure the final result perfectly represents Master-HR's professional brand and services.
