<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        DB::table('categories')->insert([
            ['name' => 'التكنولوجيا','description' => 'وظائف في مجال التكنولوجيا والبرمجة','icon' => 'fas fa-microchip'],
            ['name' => 'التسويق','description' => 'وظائف في مجال التسويق والإعلان','icon' => 'fas fa-bullhorn'],
            ['name' => 'التمويل','description' => 'وظائف في مجال التمويل والمحاسبة','icon' => 'fas fa-chart-line'],
            ['name' => 'الرعاية الصحية','description' => 'وظائف في مجال الرعاية الصحية','icon' => 'fas fa-hospital'],
            ['name' => 'التعليم','description' => 'وظائف في مجال التعليم والتدريب','icon' => 'fas fa-graduation-cap'],
            ['name' => 'التصنيع','description' => 'وظائف في مجال التصنيع والإنتاج','icon' => 'fas fa-industry'],
            ['name' => 'التجزئة','description' => 'وظائف في مجال البيع بالتجزئة','icon' => 'fas fa-shopping-cart'],
        ]);

        DB::table('locations')->insert([
            ['city_name' => 'الرياض','country' => 'المملكة العربية السعودية'],
            ['city_name' => 'جدة','country' => 'المملكة العربية السعودية'],
            ['city_name' => 'الدمام','country' => 'المملكة العربية السعودية'],
            ['city_name' => 'مكة المكرمة','country' => 'المملكة العربية السعودية'],
            ['city_name' => 'المدينة المنورة','country' => 'المملكة العربية السعودية'],
            ['city_name' => 'القاهرة','country' => 'مصر'],
            ['city_name' => 'الإسكندرية','country' => 'مصر'],
            ['city_name' => 'دبي','country' => 'الإمارات العربية المتحدة'],
            ['city_name' => 'أبو ظبي','country' => 'الإمارات العربية المتحدة'],
            ['city_name' => 'الكويت','country' => 'الكويت'],
            ['city_name' => 'الدوحة','country' => 'قطر'],
            ['city_name' => 'مسقط','country' => 'عمان'],
        ]);

        DB::table('settings')->insert([
            ['setting_key' => 'site_name','setting_value' => 'Master-HR','description' => 'اسم الموقع'],
            ['setting_key' => 'site_description','setting_value' => 'منصة التوظيف الاحترافية','description' => 'وصف الموقع'],
            ['setting_key' => 'contact_email','setting_value' => 'Hrm@masterhr.com','description' => 'البريد الإلكتروني للتواصل'],
            ['setting_key' => 'contact_phone','setting_value' => '+20 100 990 0120','description' => 'رقم الهاتف للتواصل'],
            ['setting_key' => 'company_address','setting_value' => 'مدينة نصر - القاهرة، شارع مكرم عبيد، مصر','description' => 'عنوان الشركة'],
            ['setting_key' => 'max_job_applications','setting_value' => '10','description' => 'الحد الأقصى لعدد التقدم للوظائف'],
            ['setting_key' => 'job_expiry_days','setting_value' => '30','description' => 'عدد أيام انتهاء صلاحية الوظيفة'],
            ['setting_key' => 'auto_approve_companies','setting_value' => 'false','description' => 'الموافقة التلقائية على الشركات'],
        ]);

        DB::table('users')->insert([
            'username' => 'admin',
            'email' => 'admin@masterhr.com',
            'password' => bcrypt('password'),
            'user_type' => 'admin',
            'first_name' => 'مدير',
            'last_name' => 'النظام',
            'is_active' => true,
            'email_verified' => true,
            'email_verified_at' => now(),
        ]);
    }
}
