<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('jobs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies')->cascadeOnDelete();
            $table->string('job_title', 100);
            $table->text('job_description');
            $table->text('requirements')->nullable();
            $table->decimal('salary_min', 10, 2)->nullable();
            $table->decimal('salary_max', 10, 2)->nullable();
            $table->enum('job_type', ['full_time','part_time','contract','internship'])->default('full_time');
            $table->enum('experience_level', ['entry','mid','senior','executive'])->default('mid');
            $table->string('location', 100)->nullable();
            $table->foreignId('category_id')->nullable()->constrained('categories')->nullOnDelete();
            $table->text('skills_required')->nullable();
            $table->boolean('is_active')->default(true);
            $table->integer('views_count')->default(0);
            $table->integer('applications_count')->default(0);
            $table->timestamps();

            $table->index('job_title', 'idx_job_title');
            $table->index('job_type', 'idx_job_type');
            $table->index('experience_level', 'idx_experience_level');
            $table->index('location', 'idx_location');
            $table->index('category_id', 'idx_category_id');
            $table->index('is_active', 'idx_is_active');
            $table->index(['salary_min','salary_max'], 'idx_salary_range');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('jobs');
    }
};


