<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('locations', function (Blueprint $table) {
            $table->id();
            $table->string('city_name', 100);
            $table->string('country', 100);
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->index('city_name', 'idx_city_name');
            $table->index('country', 'idx_country');
            $table->index('is_active', 'idx_is_active');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('locations');
    }
};


