<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->string('company_name', 100);
            $table->string('industry', 50);
            $table->string('company_email', 100);
            $table->string('company_phone', 20)->nullable();
            $table->string('company_website', 255)->nullable();
            $table->text('company_description')->nullable();
            $table->string('company_logo', 255)->nullable();
            $table->enum('company_size', ['1-10','11-50','51-200','201-500','500+'])->default('1-10');
            $table->string('location', 100)->nullable();
            $table->decimal('rating', 3, 2)->default(0.00);
            $table->boolean('is_verified')->default(false);
            $table->timestamps();

            $table->index('company_name', 'idx_company_name');
            $table->index('industry', 'idx_industry');
            $table->index('location', 'idx_location');
            $table->index('is_verified', 'idx_is_verified');
            $table->index('rating', 'idx_rating');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('companies');
    }
};


