<?php

namespace App\Policies;

use App\Models\Company;
use App\Models\User;

class CompanyPolicy
{
    public function view(User $user, Company $company)
    {
        return $user->isSuperAdmin() || ($user->isCompany() && $user->company && $user->company->id === $company->id);
    }

    public function manage(User $user, Company $company)
    {
        return $user->isSuperAdmin() || ($user->isCompany() && $user->company && $user->company->id === $company->id);
    }
}
