<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CompanyOnly
{
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::check()) {
            return redirect()->route('login.show');
        }
        $user = Auth::user();
        if ($user->user_type !== 'company') {
            return redirect('/');
        }

        // ensure the company user has a Company record
        if (!method_exists($user, 'company') || !$user->company) {
            // redirect to company registration or home if company profile not created
            return redirect()->route('register.company.show');
        }
        return $next($request);
    }
}


