<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Models\JobSeeker;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PublicRegistrationController extends Controller
{
    public function showCompanyForm()
    {
        return view('auth.register_company');
    }

    public function registerCompany(Request $request)
    {
        $data = $request->validate([
            'first_name' => ['required','string','max:50'],
            'last_name' => ['required','string','max:50'],
            'username' => ['required','string','max:50','unique:users,username'],
            'email' => ['required','email','max:100','unique:users,email'],
            'password' => ['required','string','min:6','confirmed'],
            'company_name' => ['required','string','max:100'],
            'industry' => ['required','string','max:50'],
            'company_phone' => ['nullable','string','max:20'],
            'location' => ['nullable','string','max:100'],
        ]);

        $user = User::create([
            'first_name' => $data['first_name'],
            'last_name' => $data['last_name'],
            'username' => $data['username'],
            'email' => $data['email'],
            'password' => bcrypt($data['password']),
            'user_type' => 'company',
            'is_active' => true,
            'email_verified' => false,
        ]);

        Company::create([
            'user_id' => $user->id,
            'company_name' => $data['company_name'],
            'industry' => $data['industry'],
            'company_email' => $data['email'],
            'company_phone' => $data['company_phone'] ?? null,
            'location' => $data['location'] ?? null,
        ]);

        Auth::login($user);
        return redirect()->route('company.dashboard');
    }

    public function showJobSeekerForm()
    {
        return view('auth.register_jobseeker');
    }

    public function registerJobSeeker(Request $request)
    {
        $data = $request->validate([
            'first_name' => ['required','string','max:50'],
            'last_name' => ['required','string','max:50'],
            'username' => ['required','string','max:50','unique:users,username'],
            'email' => ['required','email','max:100','unique:users,email'],
            'password' => ['required','string','min:6','confirmed'],
            'preferred_location' => ['nullable','string','max:100'],
            'education_level' => ['nullable','in:high_school,bachelor,master,phd,other'],
        ]);

        $user = User::create([
            'first_name' => $data['first_name'],
            'last_name' => $data['last_name'],
            'username' => $data['username'],
            'email' => $data['email'],
            'password' => bcrypt($data['password']),
            'user_type' => 'jobseeker',
            'is_active' => true,
            'email_verified' => false,
        ]);

        JobSeeker::create([
            'user_id' => $user->id,
            'preferred_location' => $data['preferred_location'] ?? null,
            'education_level' => $data['education_level'] ?? 'bachelor',
        ]);

        Auth::login($user);
        return redirect()->route('account.dashboard');
    }
}


