<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\NewsletterSubscriber;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;

class NewsletterSubscriberController extends Controller
{
    public function index(Request $request): View
    {
        $query = NewsletterSubscriber::query();
        if ($q = $request->string('q')->toString()) {
            $query->where('email','like',"%{$q}%");
        }
        $subscribers = $query->latest('id')->paginate(25)->withQueryString();
        return view('admin.newsletter.index', compact('subscribers'));
    }
}


