<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Location;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;

class LocationController extends Controller
{
    public function index(Request $request): View
    {
        $query = Location::query();
        if ($q = $request->string('q')->toString()) {
            $query->where('city_name','like',"%{$q}%")
                  ->orWhere('country','like',"%{$q}%");
        }
        $locations = $query->latest('id')->paginate(20)->withQueryString();
        return view('admin.locations.index', compact('locations'));
    }
}


