<?php

namespace App\Http\Controllers\Account;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ProfileController extends Controller
{
    public function edit()
    {
        $user = Auth::user();
        $jobSeeker = $user->jobSeeker;
        return view('account.profile.edit', compact('user','jobSeeker'));
    }

    public function update(Request $request)
    {
        $user = Auth::user();
        $data = $request->validate([
            'first_name' => ['required','string','max:50'],
            'last_name' => ['required','string','max:50'],
            'preferred_location' => ['nullable','string','max:100'],
            'education_level' => ['nullable','in:high_school,bachelor,master,phd,other'],
        ]);

        $user->update($data);
        if ($user->jobSeeker) {
            $user->jobSeeker->update([
                'preferred_location' => $data['preferred_location'] ?? null,
                'education_level' => $data['education_level'] ?? null,
            ]);
        }

        return redirect()->route('account.dashboard')->with('success','تم تحديث الملف');
    }
}
