<?php

namespace App\Http\Controllers\Account;

use App\Http\Controllers\Controller;
use App\Models\Job;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $jobSeeker = $user->jobSeeker;

        // Basic matching: by preferred_location and education_level and keywords in skills
        $query = Job::query()->where('is_active', true)->with('company');
        if ($jobSeeker && $jobSeeker->preferred_location) {
            $query->where('location', 'like', "%{$jobSeeker->preferred_location}%");
        }
        if ($jobSeeker && $jobSeeker->education_level) {
            // prioritise experience_level mapping, not strict
        }
        $jobs = $query->latest('id')->limit(20)->get();
        return view('account.dashboard', compact('jobSeeker','jobs'));
    }
}
