<?php

namespace App\Http\Controllers\Account;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ApplicationController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $jobSeeker = $user->jobSeeker;
        $applications = $jobSeeker ? $jobSeeker->applications()->with('job.company')->latest('id')->paginate(12) : collect();
        return view('account.applications.index', compact('applications'));
    }
}
